-- Criar banco de dados
CREATE DATABASE IF NOT EXISTS deploy_palace CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

USE deploy_palace;

-- Tabela de usuários (admin)
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    email VARCHAR(255) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Tabela de aplicativos
CREATE TABLE IF NOT EXISTS apps (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    developer VARCHAR(255) NOT NULL,
    description TEXT,
    icon_url TEXT,
    rating DECIMAL(2,1) DEFAULT 0.0,
    downloads INT DEFAULT 0,
    category VARCHAR(100),
    screenshots TEXT,
    version VARCHAR(50),
    size VARCHAR(50),
    download_url TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Inserir usuário admin padrão
INSERT INTO users (email, password) VALUES 
('ygreiz', '$2y$10$NXXa.C5JvhJD0DxwRNyqCeIDgQhs6epj4ZxWYq3aFoL9xTX68LCdC');

-- Inserir alguns apps de exemplo
INSERT INTO apps (name, developer, description, icon_url, rating, downloads, category, screenshots, version, size, download_url) VALUES
('WhatsApp', 'Meta', 'Mensagens instantâneas e chamadas de vídeo gratuitas', 'https://images.unsplash.com/photo-1611746872915-64382b5c76da?w=200', 4.5, 5000000000, 'Comunicação', '["https://images.unsplash.com/photo-1611746872915-64382b5c76da?w=800"]', '2.24.1', '65 MB', '#'),
('Instagram', 'Meta', 'Compartilhe fotos e vídeos com amigos', 'https://images.unsplash.com/photo-1611162617474-5b21e879e113?w=200', 4.3, 2000000000, 'Redes Sociais', '["https://images.unsplash.com/photo-1611162617474-5b21e879e113?w=800"]', '315.0', '45 MB', '#'),
('TikTok', 'ByteDance', 'Vídeos curtos e entretenimento', 'https://images.unsplash.com/photo-1611162616305-c69b3fa7fbe0?w=200', 4.6, 3000000000, 'Entretenimento', '["https://images.unsplash.com/photo-1611162616305-c69b3fa7fbe0?w=800"]', '33.1.4', '180 MB', '#'),
('Spotify', 'Spotify AB', 'Música e podcasts para todos', 'https://images.unsplash.com/photo-1614680376593-902f74cf0d41?w=200', 4.4, 500000000, 'Música', '["https://images.unsplash.com/photo-1614680376593-902f74cf0d41?w=800"]', '8.9.10', '95 MB', '#'),
('Netflix', 'Netflix Inc.', 'Filmes, séries e muito mais', 'https://images.unsplash.com/photo-1574375927938-d5a98e8ffe85?w=200', 4.2, 1000000000, 'Entretenimento', '["https://images.unsplash.com/photo-1574375927938-d5a98e8ffe85?w=800"]', '8.107.0', '40 MB', '#'),
('YouTube', 'Google LLC', 'Assista, crie e compartilhe vídeos', 'https://images.unsplash.com/photo-1611162618071-b39a2ec055fb?w=200', 4.1, 10000000000, 'Vídeo', '["https://images.unsplash.com/photo-1611162618071-b39a2ec055fb?w=800"]', '19.05.35', '155 MB', '#'),
('Telegram', 'Telegram FZ-LLC', 'Mensagens rápidas e seguras', 'https://images.unsplash.com/photo-1611605698335-8b1569810432?w=200', 4.7, 900000000, 'Comunicação', '["https://images.unsplash.com/photo-1611605698335-8b1569810432?w=800"]', '10.6.2', '85 MB', '#'),
('Uber', 'Uber Technologies', 'Peça viagens com facilidade', 'https://images.unsplash.com/photo-1449965408869-eaa3f722e40d?w=200', 4.0, 500000000, 'Transporte', '["https://images.unsplash.com/photo-1449965408869-eaa3f722e40d?w=800"]', '4.478.10', '120 MB', '#');
